load('Figure1S1_Data.mat')
%% control size
CntMeanSize=mean(Cnt_size);
%% control Proliferation rates
[ControlCount0,gof0]=fit(TimeAxis_2(1:11),log(CellNum_Cnt1(1:11)),'poly1','exclude',2);
[ControlCount1,gof1]=fit(TimeAxis_2(1:5),log(CellNum_Cnt1(1:5)),'poly1','exclude',2,'weight',[1 1 1 1 4]);
[ControlCount2,gof2]=fit(TimeAxis_2(5:11),log(CellNum_Cnt1(5:11)),'poly1','weight',[4 1 1 1 1 1 1]);
E_alpha_Cntr_0=gof0.sse/diff(TimeAxis_2([1 5]));
E_alpha_Cntr_1=gof1.sse/diff(TimeAxis_2([1 5]));
E_alpha_Cntr_2=gof2.sse/diff(TimeAxis_2([5 11]));
%% 7uM Rapamycin Proliferation rates
[RapamycinCountFit1,gofR1]=fit(TimeAxis_2(1:5),log(CellNum_7uM_Rap(1:5)),'poly1','exclude',2,'weight',[1 1 1 1 4]);
[RapamycinCountFit2,gofR2]=fit(TimeAxis_2(5:11),log(CellNum_7uM_Rap(5:11)),'poly1','weight',[4 1 1 1 1 1 1]);
E_alpha_7uM_Rap_1=gofR1.sse/diff(TimeAxis_2([1 5]));
E_alpha_7uM_Rap_2=gofR2.sse/diff(TimeAxis_2([5 11]));

%% 7uM rapamycin1 size
[RapamycinSize1]=fit(TimeAxis_1(1:4),Normalized_Rapamycin_Size_7uM(1:4)','poly1');
RapamycinSize2=mean(Normalized_Rapamycin_Size_7uM(4:8));

%% Rapamycin1 Growth Rate curve
RapamycinTotalMass1=RapamycinSize1(5:0.1:30).*exp(RapamycinCountFit1(5:0.1:30));
DerivativeMass=diff(RapamycinTotalMass1)/0.1;
Rap_GR1=DerivativeMass./exp(RapamycinCountFit1(5.1:0.1:30));

RapamycinTotalMass2=RapamycinSize2*exp(RapamycinCountFit2(30:0.1:60));
DerivativeMass=diff(RapamycinTotalMass2)/0.1;
Rap_GR2=DerivativeMass./exp(RapamycinCountFit2(30.1:0.1:60));
D=diff(confint(RapamycinCountFit2,0.25)); %%
Error_Rap_GR2=D(1);                  %%

CntTotalMass1=1*exp(ControlCount0(5:0.1:30));
DerivativeMass=diff(CntTotalMass1)/0.1;
Cnt_GR1=DerivativeMass./exp(ControlCount0(5.1:0.1:30));
D=diff(confint(ControlCount0,0.25));      %%
Error_Cnt_GR1=D(1)/2;                  %%

CntTotalMass2=1*exp(ControlCount0(30:0.1:60));
DerivativeMass=diff(CntTotalMass2)/0.1;
Cnt_GR2=DerivativeMass./exp(ControlCount0(30.1:0.1:60));
D=diff(confint(ControlCount0,0.25));      %%
Error_Cnt_GR2=D(1)/2;                  %%

Rapamycin1_GR1=Rap_GR1(15);
Rapamycin1_GR2=Rap_GR2(40);
Rapamycin1_CellCycleLength1=log(2)/RapamycinCountFit1.p1;
Rapamycin1_CellCycleLength2=log(2)/RapamycinCountFit2.p1;
D=diff(confint(RapamycinCountFit2,0.25)); %%
Error_Rap_tau2=abs(log(2)/RapamycinCountFit2.p1-log(2)/(RapamycinCountFit2.p1+D(1)));
Error_Rap_tau1=abs(log(2)/RapamycinCountFit1.p1-log(2)/(RapamycinCountFit1.p1+D(1)));

Cnt1_GR1=Cnt_GR1(15);
Cnt1_GR2=Cnt_GR2(40);
Cnt1_CellCycleLength1=log(2)/ControlCount1.p1;
Cnt1_CellCycleLength2=log(2)/ControlCount2.p1;
D=diff(confint(ControlCount1,0.25)); %%
Error_Cnt_tau1=abs(log(2)/ControlCount0.p1-log(2)/(ControlCount0.p1+D(1)));              %%

EGR(1)=E_alpha_Cntr_1;
EGR(2)=E_alpha_Cntr_2;
EGR(5)=E_alpha_7uM_Rap_1;
EGR(6)= E_alpha_7uM_Rap_2;
% 
ETau(1)=abs(log(2)/ControlCount1.p1-log(2)/(ControlCount1.p1+E_alpha_Cntr_1));
ETau(2)=abs(log(2)/ControlCount2.p1-log(2)/(ControlCount2.p1+E_alpha_Cntr_2));
ETau(5)=abs(log(2)/RapamycinCountFit1.p1-log(2)/(RapamycinCountFit1.p1+E_alpha_7uM_Rap_1));
ETau(6)=abs(log(2)/RapamycinCountFit2.p1-log(2)/(RapamycinCountFit2.p1+E_alpha_7uM_Rap_2));

%% 0.07 uM rapamycin1 & control Proliferation rates
[ControlCount0]=fit(TimeAxis_2(1:11),log(CellNum_Cnt1(1:11)),'poly1','exclude',2);
[ControlCount1]=fit(TimeAxis_2(1:5),log(CellNum_Cnt1(1:5)),'poly1','weight',[1 1 1 1 4]);
[ControlCount2]=fit(TimeAxis_2(5:11),log(CellNum_Cnt1(5:11)),'poly1','weight',[4 1 1 1 1 1 1]);
[RapamycinCountFit0]=fit(TimeAxis_2(1:3),log(CellNum_07uM_Rap(1:3)),'poly1');
[RapamycinCountFit1,gof1]=fit(TimeAxis_2(1:5),log(CellNum_07uM_Rap(1:5)),'poly1','weight',[1 1 1 1 4],'exclude',2);
[RapamycinCountFit2,gof2]=fit(TimeAxis_2(5:8),log(CellNum_07uM_Rap(5:8)),'poly1','weight',[4 1 1 1]);
E_alpha_07uM_Rap_1=gof1.sse/diff(TimeAxis_2([1 5]));
E_alpha_07uM_Rap_2=gof2.sse/diff(TimeAxis_2([5 8]));
%% 0.07 uM rapamycin1 & control size
[DPC_CellCount_Cnt]=fit(TimeAxis_2,log(CellNum_Cnt1),'poly1');
[DPC_CellCount_Rapamycin_0]=fit(TimeAxis_2(2:11),log(CellNum_07uM_Rap(2:11)),'poly3');
[RapamycinSize1]=fit(TimeAxis_1(1:5),Normalized_Rapamycin_Size_07uM(1:5)','poly1');
RapamycinSize2=mean(Normalized_Rapamycin_Size_07uM(5:8));
%% Rapamycin1 Growth Rate curve
RapamycinTotalMass1=RapamycinSize1(5:0.1:30).*exp(RapamycinCountFit1(5:0.1:30));
DerivativeMass=diff(RapamycinTotalMass1)/0.1;
Rap_GR1=DerivativeMass./exp(RapamycinCountFit1(5.1:0.1:30));
D=diff(confint(RapamycinCountFit1,0.25)); %%
Error_Rap_GR1=D(1)/2;                  %%

RapamycinTotalMass2=RapamycinSize2*exp(RapamycinCountFit2(30:0.1:60));
DerivativeMass=diff(RapamycinTotalMass2)/0.1;
Rap_GR2=DerivativeMass./exp(RapamycinCountFit2(30.1:0.1:60));
D=diff(confint(RapamycinCountFit1,0.25)); %%
Error_Rap_GR2=D(1)/2;                  %%

CntTotalMass1=1*exp(ControlCount1(5:0.1:30));
DerivativeMass=diff(CntTotalMass1)/0.1;
Cnt_GR1=DerivativeMass./exp(ControlCount1(5.1:0.1:30));
D=diff(confint(ControlCount0,0.25));      %%
Error_Cnt_GR1=D(1);                  %%

CntTotalMass2=1*exp(ControlCount2(30:0.1:60));
DerivativeMass=diff(CntTotalMass2)/0.1;
Cnt_GR2=DerivativeMass./exp(ControlCount2(30.1:0.1:60));
D=diff(confint(ControlCount0,0.25));      %%
Error_Cnt_GR2=D(1);                  %%

Rapamycin2_GR1=Rap_GR1(15);
Rapamycin2_GR2=Rap_GR2(40);
Rapamycin2_CellCycleLength1=log(2)/RapamycinCountFit1.p1;
Rapamycin2_CellCycleLength2=log(2)/RapamycinCountFit2.p1;
D=diff(confint(RapamycinCountFit1,0.25)); %%
Error_Rap_tau1=abs(log(2)/RapamycinCountFit1.p1-log(2)/(RapamycinCountFit1.p1+D(1)));              %%
D=diff(confint(RapamycinCountFit2,0.25)); %%
Error_Rap_tau2=abs(log(2)/RapamycinCountFit2.p1-log(2)/(RapamycinCountFit2.p1+D(1)));              %%

Cnt2_GR1=Cnt_GR1(15);
Cnt2_GR2=Cnt_GR2(40);
Cnt2_CellCycleLength1=log(2)/ControlCount1.p1;
Cnt2_CellCycleLength2=log(2)/ControlCount2.p1;
D=diff(confint(ControlCount1,0.25)); %%
Error_Cnt_tau1=1/D(1)^2;              %%
D=diff(confint(ControlCount1,0.25)); %%
Error_Cnt_tau2=1/D(1)^2;              %%s

EGR(3)=Error_Rap_GR1;
EGR(4)=Error_Rap_GR2;

ETau(3)=Error_Rap_tau1;
ETau(4)=Error_Rap_tau2;

EGR(3)=E_alpha_07uM_Rap_1;
EGR(4)=E_alpha_07uM_Rap_2;
% 
ETau(3)=abs(log(2)/RapamycinCountFit1.p1-log(2)/(RapamycinCountFit1.p1+E_alpha_07uM_Rap_1));
ETau(4)=abs(log(2)/RapamycinCountFit2.p1-log(2)/(RapamycinCountFit2.p1+E_alpha_07uM_Rap_2));

%% 39 nM SN032 proliferation rates
[DrugCount0]=fit(TimeAxis_2(2:11),log(CellNum_39nM_SN032(2:11)),'poly1');
[DrugCount1,gof1]=fit(TimeAxis_2(2:6),log(CellNum_39nM_SN032(2:6)),'poly1');
[DrugCount2,gof2]=fit(TimeAxis_2(6:11),log(CellNum_39nM_SN032(6:11)),'poly1');

E_alpha_39uM_SN_1=gof1.sse/diff(TimeAxis_2([2 6]));
E_alpha_39uM_SN_2=gof2.sse/diff(TimeAxis_2([6 11]));
%% 39 nM SN032 size 
[DPC_CellCount_Cnt]=fit(TimeAxis_2,log(CellNum_Cnt1),'poly1');
[DPC_CellCount_Drug_0]=fit(TimeAxis_2(2:11),log(CellNum_39nM_SN032(2:11)),'poly3');
[SizeDrug1]=fit(TimeAxis_1([1:5]),Normalized_SN032_39nM_Size([1:5])','poly1');
[SizeDrug2]=mean(Normalized_SN032_39nM_Size([5:8]));
[SizeDrug3]=mean(Normalized_SN032_39nM_Size([6:8]));
[SizeDrug0]=fit(TimeAxis_1([1:8]),Normalized_SN032_39nM_Size([1:8])','exp2');

%% 39nM SN032 Growth Rate curve
DrugTotalMass1=SizeDrug1(5:0.1:30).*exp(DrugCount0(5:0.1:30));
DerivativeMass=diff(DrugTotalMass1)/0.1;
Drug_GR1=DerivativeMass./exp(DrugCount0(5.1:0.1:30));
D=diff(confint(DrugCount0,0.25));
Error_Drug_GR1=D(1); 

DrugTotalMass2=SizeDrug2*exp(DrugCount0(30:0.1:60));
DerivativeMass=diff(DrugTotalMass2)/0.1;
Drug_GR2=DerivativeMass./exp(DrugCount0(30.1:0.1:60));
D=diff(confint(DrugCount0,0.25));
Error_Drug_GR2=D(1); 

CntTotalMass1=1*exp(ControlCount1(5:0.1:30));
DerivativeMass=diff(CntTotalMass1)/0.1;
Cnt_GR1=DerivativeMass./exp(ControlCount1(5.1:0.1:30));

CntTotalMass2=1*exp(ControlCount2(30:0.1:60));
DerivativeMass=diff(CntTotalMass2)/0.1;
Cnt_GR2=DerivativeMass./exp(ControlCount2(30.1:0.1:60));

Drug1_GR1=Drug_GR1(15);
Drug1_GR2=Drug_GR2(40);
Drug1_CellCycleLength1=log(2)/DrugCount1.p1;
Drug1_CellCycleLength2=log(2)/DrugCount2.p1;
D=diff(confint(DrugCount0,0.25)); %%
Error_Rap_tau1=abs(log(2)/DrugCount1.p1-log(2)/(DrugCount1.p1+D(1)));              %%

Cnt3_GR1=Cnt_GR1(15);
Cnt3_GR2=Cnt_GR2(30);
Cnt3_CellCycleLength1=log(2)/ControlCount1.p1;
Cnt3_CellCycleLength2=log(2)/ControlCount2.p1;

EGR(9)=E_alpha_39uM_SN_1;
EGR(10)=E_alpha_39uM_SN_2;
% 
ETau(9)=abs(log(2)/DrugCount1.p1-log(2)/(DrugCount1.p1+E_alpha_39uM_SN_1));
ETau(10)=abs(log(2)/DrugCount2.p1-log(2)/(DrugCount2.p1+E_alpha_39uM_SN_2));

%% 19.5 nM SN032 proliferation rates
[SecondContCount1]=fit(TimeAxis_2(1:9),log(CellNum_Cnt1(1:9)),'poly1','exclude',3);
[SecondContCount2]=fit(TimeAxis_2(1:9),log(CellNum_Cnt1(1:9)),'poly1','exclude',3);
[DrugCount0,gof0]=fit(TimeAxis_2(2:8),log(CellNum_19nM_SN032(2:8)),'poly1','exclude',[2 3]);
[DrugCount1,gof1]=fit(TimeAxis_2(2:5),log(CellNum_19nM_SN032(2:5)),'poly1','exclude',[2 3]);
[DrugCount2,gof2]=fit(TimeAxis_2(5:8),log(CellNum_19nM_SN032(5:8)),'poly1');

E_alpha_19uM_SN_1=gof0.sse/diff(TimeAxis_2([2 5]));
E_alpha_19uM_SN_2=gof0.sse/diff(TimeAxis_2([5 8]));

%% 19.5 nM SN032 size

[SizeDrug1]=fit(TimeAxis_1([1:4]),Normalized_19nM_SN032_Size([1:4])','poly1');
[SizeDrug2]=mean(Normalized_19nM_SN032_Size([5:8]));
[SizeDrug3]=mean(Normalized_19nM_SN032_Size([6:8]));
[SizeDrug0]=fit(TimeAxis_1([1:8]),Normalized_19nM_SN032_Size([1:8])','exp2');
%% 19.5 nM SN032 Growth Rate curve
DrugTotalMass1=SizeDrug1(5:0.1:30).*exp(DrugCount0(5:0.1:30));
DerivativeMass=diff(DrugTotalMass1)/0.1;
Drug_GR1=DerivativeMass./exp(DrugCount0(5.1:0.1:30));
D=diff(confint(DrugCount0,0.25)); 
Error_Drug_GR1=D(1); 

DrugTotalMass2=SizeDrug2*exp(DrugCount0(30:0.1:60));
DerivativeMass=diff(DrugTotalMass2)/0.1;
Drug_GR2=DerivativeMass./exp(DrugCount0(30.1:0.1:60));
D=diff(confint(DrugCount0,0.25)); 
Error_Drug_GR2=D(1); 

CntTotalMass1=1*exp(ControlCount1(5:0.1:30));
DerivativeMass=diff(CntTotalMass1)/0.1;
Cnt_GR1=DerivativeMass./exp(ControlCount1(5.1:0.1:30));

CntTotalMass2=1*exp(ControlCount2(30:0.1:60));
DerivativeMass=diff(CntTotalMass2)/0.1;
Cnt_GR2=DerivativeMass./exp(ControlCount2(30.1:0.1:60));

Drug2_GR1=Drug_GR1(15);
Drug2_GR2=Drug_GR2(50);
D=diff(confint(DrugCount0,0.25));
Error_Drug_Tau1=abs(log(2)/DrugCount1.p1-log(2)/(DrugCount1.p1+D(1)));
Error_Drug_Tau2=abs(log(2)/DrugCount1.p1-log(2)/(DrugCount1.p1+D(1)));

Drug2_CellCycleLength1=log(2)/DrugCount1.p1;
Drug2_CellCycleLength2=log(2)/DrugCount2.p1;

Cnt4_GR1=Cnt_GR1(15);
Cnt4_GR2=Cnt_GR2(50);
Cnt4_CellCycleLength1=log(2)/ControlCount1.p1;
Cnt4_CellCycleLength2=log(2)/ControlCount2.p1;

EGR(7)=E_alpha_19uM_SN_1;
EGR(8)=E_alpha_19uM_SN_2;
% 
ETau(7)=abs(log(2)/DrugCount1.p1-log(2)/(DrugCount1.p1+E_alpha_19uM_SN_1));
ETau(8)=abs(log(2)/DrugCount2.p1-log(2)/(DrugCount2.p1+E_alpha_19uM_SN_2));

%******************************************************************************************************************************
GR=[Cnt1_GR1 Cnt1_GR2 ...
    Rapamycin2_GR1 Rapamycin2_GR2 ...
    Rapamycin1_GR1 Rapamycin1_GR2 ...
    Drug2_GR1 Drug2_GR2 ...
    Drug1_GR1 Drug1_GR2 ];

Tau=[Cnt1_CellCycleLength1 Cnt1_CellCycleLength2 ...
    Rapamycin2_CellCycleLength1 Rapamycin2_CellCycleLength2 ...
    Rapamycin1_CellCycleLength1 Rapamycin1_CellCycleLength2 ...
    Drug2_CellCycleLength1 Drug2_CellCycleLength2 ...
    Drug1_CellCycleLength1 Drug1_CellCycleLength2];

E=EGR.*GR;
i=1;dmso=[100*GR(2*i-1:2*i)/mean(GR(1:2))];dmsoER=[50*100*E(2*i-1:2*i)/mean(GR(1:2))];
i=4;sns=[100*GR(2*i-1:2*i)/mean(GR(1:2))];snsER=[50*100*E(2*i-1:2*i)/mean(GR(1:2))];

% figure;h=bar([dmso;sns]);hold on;
% h(1).FaceColor='flat'; h(1).CData=[0 83 125]./255; hold on;
% h(2).FaceColor='flat'; h(2).CData=[194 87 87]./255; hold on;
% errorbar([0.86 1.14 1.86 2.14],[dmso,sns],[dmsoER,snsER],'color','k','linestyle','none');
% set(gca,'xtick',1:2,'xticklabel',{''})

figure;clf;h=bar(1,dmso(1));hold on;h.FaceColor='flat';h.CData=[0 0.3255 0.4902]*1.1;
errorbar(1,dmso(1),dmsoER(1),'color','k','linestyle','none');
h=bar(2,sns(1));hold on;h.FaceColor='flat';h.CData=[0.7608 0.3412 0.3412]*1.1;
errorbar(2,sns(1),snsER(1),'color','k','linestyle','none');
h=bar(4,dmso(2));hold on;h.FaceColor='flat';h.CData=[0 0.3255 0.4902]*1.1;
errorbar(4,dmso(2),dmsoER(2),'color','k','linestyle','none');
h=bar(5,sns(2));hold on;h.FaceColor='flat';h.CData=[0.7608 0.3412 0.3412]*1.1;
errorbar(5,sns(2),snsER(2),'color','k','linestyle','none');
ylabel('Growth Rate (% of control)'); ylim([0 150])
set(gca,'xtick',[1.5 4.5],'xticklabel',{'Early Stage','Late Stage'},'fontsize',14)


